/***************************************************************************
 *
 * Copyright (c) 2013 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#ifndef BUTTON_SUBDIVISION_H_INCLUDED
#define BUTTON_SUBDIVISION_H_INCLUDED

#include <sys/types.h>

#include <fstream>
#include <string>

#include "CalibrationTypes.h"
#include "Subdivision.h"

using namespace std;

namespace LayerManagerCalibration
{
    class ButtonSubdivision : public Subdivision
    {
    public:
        ButtonSubdivision();
        uint getKeyCode();
        float getMinimumRepetitionInterval();
        bool validate();

    protected:
        virtual ~ButtonSubdivision();
        bool handleUnknownKey(const string& key, const string& value);

    private:
        uint m_u32KeyCode;
        float m_fpMinimumRepetitionInterval;

        bool m_bKeyCodeParsed;
        bool m_bMinimumRepetitionIntervalParsed;
    };

    inline ButtonSubdivision::ButtonSubdivision()
        : Subdivision(BUTTON),
          m_bKeyCodeParsed(false),
          m_bMinimumRepetitionIntervalParsed(false)
    {
    }

    inline ButtonSubdivision::~ButtonSubdivision()
    {
    }

    inline uint ButtonSubdivision::getKeyCode()
    {
        return m_u32KeyCode;
    }

    inline float ButtonSubdivision::getMinimumRepetitionInterval()
    {
        return m_fpMinimumRepetitionInterval;
    }
}

#endif
